<?php
/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2011 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
  Desclares the variables, constants, and classes used by the image or image
  group display page.
-------------------------------------------------------------------------------
  $Id: img-classes.php 186 2011-12-17 15:50:12Z dirk $
===============================================================================
*/

error_reporting(E_ERROR | E_WARNING | E_PARSE);

include 'img-loader.php';

/*
-------------------------------------------------------------------------------
  V a r i a b l e   I n i t i a l i z a t i o n s
===============================================================================
*/

// Name of the directory containing this file and the series directories.
$g_seriesBaseDir = $_SERVER['DOCUMENT_ROOT'] . '/photo';
// File extension of image files defined by JPhoto-Explorer.
$g_imageExtension = '.jpg';

$g_monthNames = array('', 'January', 'February', 'March', 'April', 'May',
    'June', 'July', 'August', 'September', 'October', 'November', 'December');

// Constant definitions: standard names.
define("REFERENCE"     , "reference:");
define("SEPARATOR"     , "separator:");

// Constant definitions: standard properties.
define("TITLE"         , "title");
define("SUBTITLE"      , "subtitle");
define("HREF"          , "href");
define("DATE_BEGIN"    , "date-begin");
define("DATE_END"      , "date-end");
define("DESCRIPTION"   , "description");
define("REMARK"        , "remark");

// Constant definitions: Get date constants.
define("GET_BEGIN_DATE", 1);
define("GET_END_DATE"  , 0);
define("SHORT"         , 1);
define("LONG"          , 0);
define("AS_HTML"       , 1);
define("AS_PLAIN"      , 0);

/*
-------------------------------------------------------------------------------
  Class:    "BaseFSObject"
  Function: Base class for files and groups and that holds the common metadata.
===============================================================================
*/

class BaseFSObject
{
    var $fileName;
    var $parentDir;
    var $title;
    var $subtitle;
    var $description;
    var $location;
    var $beginDate;
    var $endDate;
    var $href;
    var $remark;
    var $previous;
    var $next;

    function BaseFSObject ($fileName, &$parentDir)
    {
        $this->fileName = $fileName;
        $this->parentDir = &$parentDir;
        $this->title = $this->subtitle = $this->description = '';
        $this->location = $this->beginDate = $this->endDate = '';
        $this->href = $this->remark = '';
        $this->previous = null;
        $this->next = null;
    } // BaseFSObject constructor

    /* Sets a property value. */
    function set ($name, $value)
    {
        if (!strcmp($name, TITLE))
            $this->title = $value;
        else if (!strcmp($name, SUBTITLE))
            $this->subtitle = $value;
        else if (!strcmp($name, DESCRIPTION))
            $this->description = $value;
        else if (!strcmp($name, DATE_BEGIN))
            $this->beginDate = $value;
        else if (!strcmp($name, DATE_END))
            $this->endDate = $value;
        else if (!strcmp($name, HREF))
        {
            $this->href = $value;
            $this->fileName = REFERENCE;
        }
        else if (!strcmp($name, REMARK))
            $this->remark = $value;
    } // set

    function isSeparator ()
    {
        return (!strcasecmp($this->fileName, SEPARATOR));
    } // isSeparator

    function isReference ()
    {
        return (!strcasecmp($this->fileName, REFERENCE) ||
            strlen($this->href) > 0 || $this->isSeparator());
    } // isReference

    function &getPrevNotRef ()
    {
        $p = &$this->previous;
        while (is_object($p) && $p->isReference())
            $p = &$p->previous;
        return $p;
    } // getPrevNotRef

    function &getNextNotRef ()
    {
        $p = &$this->next;
        while (is_object($p) && $p->isReference())
            $p = &$p->next;
        return $p;
    } // getPrevNotRef
    
    /* Gets the date setting of this instance. */
    function getDate ($bBeginDate, $bShort, $bWithTime, $bAsHtml)
    {
        if ($bBeginDate)
            $arr = split('-', $this->beginDate);
        else
            $arr = split('-', $this->endDate);
        $sep = $bAsHtml ? '&nbsp;' : ' ';
        $year = $arr[0];
        $month = $arr[1];
        $day = $arr[2];
        $hour = $arr[3];
        $min = $arr[4];
        $sec = $arr[5];
        $str = '';
        if ($bShort)
        {
            if ($day)
                $str .= (($day <= 9) ? '0' : '') . $day . '.';
            if ($month)
                $str .= (($month <= 9) ? '0' : '') . $month . '.';
            if ($year)
                $str .= $year;
        }
        else
        {
            if ($day > 0)
                $str .= $day . $sep;
            if ($month > 0)
                $str .= $g_monthNames[$month];
            if ($day > 0)
                $str .= ',';
            $str .= $sep;
            if ($year > 0)
                $str .= $year;
        }
        if ($bWithTime && $hour)
        {
            $str .= $sep . "(" . (($hour <= 9) ? "0" : "") . $hour . ":"
                . (($min <= 9) ? "0" : "") . $min;
            if ($sec > 0)
                $str .= ":" . (($sec <= 9) ? "0" : "") . $sec;
            $str .= ")";
        }
        return $str;
    } // getDate

    /* Gets the year of this instance. */
    function getYear ($bBeginDate)
    {
        if ($bBeginDate && strlen($this->beginDate) > 0)
        {
            $arr = split('-', $this->beginDate);
            return $arr[0];
        }
        else if (strlen($this->endDate) > 0)
        {
            $arr = split('-', $this->endDate);
            return $arr[0];
        }
        else if (is_object($this->parentDir))
            return $this->parentDir->getYear($bBeginDate);
        return "";
    } // getYear

    /* Gets the description with '\n\n' replaced with <p>. */
    function getDescription ($cssClass)
    {
        $repl = $cssClass ? "</p>\n<p class=\"$cssClass\">" : "</p>\n<p>";
        return str_replace("\n\n", $repl, $this->description);
    } // getDescription

    /* Gets the file base name (without extension). */
    function getBaseName ()
    {
        $name = $this->fileName;
        $pos = strpos($name, '.');
        if ($pos === false)
            return $name;
        return substr($name, 0, $pos);
    } // getBaseName
                
    /* Gets the relative path beginning with the series directory name. */
    function getPath ()
    {
        $p = &$this;
        $path = $this->fileName;
        while (is_object($p))
        {
            $p = &$p->parentDir;
            if (is_object($p))
                $path = $p->fileName . '/' . $path;
        }
        return $path;
    } // getPath

    /* Debug method. */
    function dumpIndent ($indent, $str)
    {
        for ($i = 1; $i <= $indent; $i++) echo ' ';
        echo $str;
    } // dumpIndent
    function dump ($indent)
    {
        $this->dumpIndent($indent, 'File Name:   ' . $this->fileName);
        if (is_object($this->parentDir))
            echo ' (parent: ' . $this->parentDir->fileName . ')';
        echo "\n";
        $this->dumpIndent($indent, 'Title:       ' . $this->title);
        if (strlen($this->subtitle) > 0)
            echo ' (' . $this->subtitle . ')';
        echo "\n";
        if (strlen($this->location) > 0)
            $this->dumpIndent($indent, 'Location:    '. $this->location. "\n");
        if (strlen($this->beginDate) > 0)
            $this->dumpIndent($indent, 'Begin Date:  ' . $this->beginDate);
        if (strlen($this->endDate) > 0)
            echo ', End Date: ' . $this->endDate;
        echo "\n";
        if (strlen($this->description) > 0)
            $this->dumpIndent($indent,'Description: '.$this->description."\n");
        if (strlen($this->href) > 0)
            $this->dumpIndent($indent, 'HRef:        ' . $this->href . "\n");
        if (strlen($this->remark) > 0)
            $this->dumpIndent($indent, 'Remark:      ' . $this->remark . "\n");
    } // dump
} // BaseFSObject

/*
-------------------------------------------------------------------------------
  Class:    "DirectoryObject"
  Function: Class for directories (groups).
===============================================================================
*/

class DirectoryObject extends BaseFSObject
{
    var $firstSubGroup;
    var $lastSubGroup;
    var $firstFile;
    var $lastFile;
    var $fileCount;
    var $prevInAllGroups;
    var $nextInAllGroups;
    
    function DirectoryObject ($fileName, &$parentDir)
    {
        BaseFSObject::BaseFSObject($fileName, $parentDir);
        $this->firstSubGroup = null;
        $this->lastSubGroup = null;
        $this->firstFile = null;
        $this->lastFile = null;
        $this->fileCount = 0;
        $this->prevInAllGroups = $this->nextInAllGroups = null;
        if (is_object($this->parentDir))
            $this->parentDir->addSubGroup($this);
    } // DirectoryObject constructor
    
    /* Adds a subgroup. */
    function addSubGroup (&$groupObj)
    {
        if (!is_object($this->firstSubGroup))
        {
            $this->firstSubGroup = &$groupObj;
            $this->lastSubGroup = &$groupObj;
        }
        else
        {
            $groupObj->previous = &$this->lastSubGroup;
            $this->lastSubGroup->next = &$groupObj;
            $this->lastSubGroup = &$groupObj;
        }
    } // addSubGroup

    /* Adds a file to a group. */
    function addFile (&$fileObj)
    {
        if ($this->firstFile == null)
        {
            $this->firstFile = &$fileObj;
            $this->lastFile = &$fileObj;
        }
        else
        {
            $fileObj->previous = &$this->lastFile;
            $this->lastFile->next = &$fileObj;
            $this->lastFile = &$fileObj;
        }
        if (!$fileObj->isReference())
            $this->fileCount++;
    } // addFile

    /* Debug method. */
    function dump ($indent)
    {
        parent::dump($indent);
        $this->dumpIndent($indent, "Sub Groups:\n");
        $sub = &$this->firstSubGroup;
        while (is_object($sub))
        {
            $sub->dump($indent + 1);
            $sub = &$sub->next;
        }
        $this->dumpIndent($indent, "Files:\n");
        $sub = &$this->firstFile;
        while (is_object($sub))
        {
            $sub->dump($indent + 1);
            $sub = &$sub->next;
        }
    } // dump
} // DirectoryObject

/*
-------------------------------------------------------------------------------
  Class:    "FileObject"
  Function: Class for files and images.
===============================================================================
*/

class FileObject extends BaseFSObject
{
    function FileObject ($fileName, &$parentDir)
    {
        BaseFSObject::BaseFSObject($fileName, $parentDir);
        if (is_object($this->parentDir))
            $this->parentDir->addFile($this);
    } // FileObject constructor
} // FileObject

/*
-------------------------------------------------------------------------------
  Class:    "SeriesObject"
  Function: Class for directories (series) that do not have a parent.
===============================================================================
*/

class SeriesObject extends DirectoryObject
{
    var $allGroupsFirst;
    var $allGroupsLast;
    
    function SeriesObject ($fileName)
    {
        // Do not call the base class constructor.
        $this->fileName = $fileName;
        $this->parentDir = null;
        $this->title = $this->subtitle = $this->description = '';
        $this->location = $this->beginDate = $this->endDate = '';
        $this->href = $this->remark = '';
        $this->previous = null;
        $this->next = null;
        $this->firstSubGroup = null;
        $this->lastSubGroup = null;
        $this->fileCount = 0;
        $this->firstFile = null;
        $this->lastFile = null;
        $this->prevInAllGroups = $this->nextInAllGroups = null;
        // Remaining instance data.
        $this->allGroupsFirst = $this->allGroupsLast = null;
        // Load the series data.
        $seriesLoader = &new SeriesLoader();
        $seriesLoader->loadSeries($this);
    } // SeriesObject constructor
    
    /* Adds a group in the series. */
    function addGroupInSeries (&$groupObj)
    {
        if ($this->allGroupsFirst == null)
        {
            $this->allGroupsFirst = &$groupObj;
            $this->allGroupsLast = &$groupObj;
        }
        else
        {
            $groupObj->prevInAllGroups = &$this->allGroupsLast;
            $this->allGroupsLast->nextInAllGroups = &$groupObj;
            $this->allGroupsLast = &$groupObj;
        }
    } // addGroupInSeries

    /*
    ---------------------------------------------------------------------------
      Group metadata functions
    ===========================================================================
    */
    function &getGroupObj ($groupName)
    {
        $groupObj = &$this->allGroupsFirst;
        while (is_object($groupObj))
        {
            if (!strcasecmp($groupObj->fileName, $groupName))
                return $groupObj;
            $groupObj = &$groupObj->nextInAllGroups;
        }
        return null;
    } // getGroupObj

    function getGroupSource (&$groupObj)
    {
        if (!is_object($groupObj))
            return null;
        return $_SERVER['PHP_SELF'] . '?s=' . $this->fileName
            . '&g=' . $groupObj->fileName;
    } // getGroupSource

    function getGroupLinkStartTag (&$groupObj)
    {
        if (!is_object($groupObj))
            return null;
        return '<a href="' . $this->getGroupSource($groupObj)
            . '" title="Go to group ' . $groupObj->title . '">';
    } // getGroupLinkStartTag

    /*
    ---------------------------------------------------------------------------
      File metadata functions
    ===========================================================================
    */
    function &getFileObj ($imgName, $groupName)
    {
        $isGroupName = (is_string($groupName) && strlen($groupName) > 0);
        $groupObj = &$this->allGroupsFirst;
        $fpattern = strtolower($imgName);
        $fpatlen = strlen($fpattern);
        while (is_object($groupObj))
        {
            if (!$isGroupName || !strcasecmp($groupObj->fileName, $groupName))
            {
                $fileObj = &$groupObj->firstFile;
                while (is_object($fileObj))
                {
                    $fname = strtolower($fileObj->fileName);
                    if (!strncmp($fname, $fpattern, $fpatlen) &&
                        (strlen($fname) == $fpatlen || $fname[$fpatlen] =='.'))
                    {
                        return $fileObj;
                    }
                    $fileObj = &$fileObj->next;
                }
            }
            $groupObj = &$groupObj->nextInAllGroups;
        }
        return null;
    } // getFileObj

    function getFileTag (&$fileObj)
    {
        if (!is_object($fileObj))
            return null;
        $title = $fileObj->title;
        $str = '';
        $bToEnd = false;
        $nextFileObj = $fileObj->getNextNotRef();
        if (is_object($nextFileObj))
        {
            $str = $this->getFileLinkStartTag($nextFileObj);
            $title .= ' ' . '(Click for next image)';
            $bToEnd = true;
        }
        else if (is_object($fileObj->parentDir->nextInAllGroups))
        {
            $nextGroupObj = &$fileObj->parentDir->nextInAllGroups;
            $str = $this->getGroupLinkStartTag($nextGroupObj);
            $title .= ' ' . '(Click for next group)';
            $bToEnd = true;
        }
        $str .= '<img border="0" src="' . $fileObj->getPath()
            . '" alt="' . $title . '" title="' . $title . '" border="0">';
        if ($bToEnd)
            $str .= '</a>';
        return $str;
    } // getFileTag

    function getFileLinkStartTag (&$fileObj)
    {
        if (!is_object($fileObj))
            return null;
        return '<a href="' . $_SERVER['PHP_SELF'] . '?s='
            . $this->fileName . "&g=" . $fileObj->parentDir->fileName
            . '&i=' . $fileObj->getBaseName()
            . '" title="Go to image ' . $fileObj->title . '">';
    } // getFileLinkStartTag

    /*
    ---------------------------------------------------------------------------
      Group display functions
    ===========================================================================
    */
    function showSubGroups (&$groupObj, $headline)
    {
        // Shows all sub groups of the group, if present.
        $subGroup = &$groupObj->firstSubGroup;
        if (!is_object($subGroup))
            return;
        if (is_string($headline) && strlen($headline) > 0)
        {
            if (is_string($groupObj->title) && strlen($groupObj->title) > 0)
                $headline = $groupObj->title;
            echo '<h1>' . $headline . "</h1>\n";
        }
        echo  "\n<table border='0' cellpadding='4' cellspacing='0'>\n";
        while (is_object($subGroup))
        {
            echo " <tr valign='top'>\n  <td width='5%' nowrap>"
               . "&nbsp; &nbsp; &nbsp;</td>\n  <td width='1%' nowrap>"
               . $this->getGroupLinkStartTag($subGroup)
               . '<img src="../images/index-arrow-right.gif" '
               . "border='0' width='16' height='16'></a>&nbsp;</td>\n  <td>"
               . $this->getGroupLinkStartTag($subGroup)
               . '<b>' . $subGroup->title . '</b>';
            if (strlen($subGroup->subtitle) > 0)
                echo ' ' . $subGroup->subtitle;
            echo '</a>';
            if (strlen($subGroup->description) > 0)
            {
                echo "\n  <p class='clsNoTop'>"
                        . $subGroup->getDescription('clsNoTop');
            }
            echo "</p>\n  </td>\n </tr>\n";
            $subGroup = &$subGroup->next;
        }
        echo  "</table>\n\n";     
    } // showSubGroups

    /* Display all images in the current group. */
    function showFiles (&$groupObj, $cols)
    {
        global $g_imageExtension;
        $fileObj = &$groupObj->firstFile;
        $bHaveSeparators = false;
        while (is_object($fileObj))
        {
            if ($fileObj->isReference())
            {
                $bHaveSeparators = true;
                break;
            }
            $fileObj = &$fileObj->next;
        }
        // Print the "Start Here" link.
        $fileObj = &$groupObj->firstFile;
        if (is_object($fileObj) && $fileObj->isReference())
            $fileObj = &$fileObj->getNextNotRef();
        if (is_object($fileObj))
        {
            echo "\n<div style='margin-bottom: 1em'>\n  "
                . $this->getFileLinkStartTag($fileObj)
                . '<img src="../images/index-arrow-right.gif" '
                . 'border="0" width="16" height="16"></a>&nbsp;'
                . $this->getFileLinkStartTag($fileObj)
                . "Start here</a> <span style='color:#999999'>or click the thumbnails for the large photos</span>\n</div>\n\n";
        }
        // Print the file table start.
        $i = 0;
        $bIsFirstRow = true;
        $bHaveTableStart = false;
        $fileObj = &$groupObj->firstFile;
        if (!is_object($fileObj) || !$fileObj->isReference())
        {
            echo "<table border='0' cellpadding='0' cellspacing='0' "
               . "width='96%'>\n";
            $bHaveTableStart = true;
        }
        while (is_object($fileObj))
        {
            // Build the tag for the file object.
            if ($fileObj->isSeparator())
            {
                // Build the separator tag.
                $tag = '&nbsp;';
            }
            else if ($fileObj->isReference())
            {
                // Build the reference tag.
                $tag = '<p class="clsLessTop">';
                if (strlen($fileObj->href) > 0)
                {
                    $tag .= '<a href="' . $fileObj->href . '"><b>'
                        . $fileObj->title . "</b></a><br>\n";
                }
                $tag .= $fileObj->getDescription('clsLessTop') . "</p>\n";
            }
            else
            {
                // Get the image source of the small preview image.
                $src = $groupObj->getPath() . '/' . $fileObj->getBaseName()
                    . '-s' . $g_imageExtension;
                // Build the image tag.
                $tag = '<img src="' . $src . '" border="0"';
                if (strlen($fileObj->title) > 0)
                    $tag .= ' alt="' . $fileObj->title . '"';
                $tag .= '>';
            }
            // Print a new row start.
            if ($bIsFirstRow || $i % $cols == 0)
            {
                if (!$bIsFirstRow)
                {
                    echo ' <tr><td colspan="' . (2 * $cols)
                         . '" style="height: 1.3em">' . "</td></tr>\n";
                }
                if ($bHaveTableStart)
                    echo " <tr>\n";
            }
            // Print the image/reference tag.
            if ($fileObj->isReference())
            {
                if (!$bIsFirstRow)
                {
                    // Close the table.
                    if ($i % $cols != 0)
                    {
                        while ($i++ % $cols != 0)
                            echo "  <td style='width: 1.5em'>&nbsp;</td>\n";
                        echo "  <td width='*' nowrap> &nbsp; </td>\n";
                    }
                    echo " </tr></table>\n";
                }
                echo '<div style="margin-top: 0.5em; margin-bottom: 0">'
                     . $tag . "</div>\n";
                // Continue with the next file.
                $fileObj = &$fileObj->next;
                if (is_object($fileObj))
                {
                    echo "<table border='0' cellpadding='0' cellspacing='0' ";
                    echo "width='96%'>\n";
                    $bHaveTableStart = true;
                }
                $i = 0;
                continue;
            }
            else
            {
                echo '  <td align="center" valign="top" width="200" '
                   . "class='photoNavigationCell'>\n";
                echo "   <table border='0' cellpadding='0' cellspacing='2'>\n"
                   . '    <tr><td width="200" height="200" align="center">';
                echo '<table border="0" cellpadding="1" cellspacing="1"' .
                     ' bgcolor="#666666">';
                echo '<tr><td bgcolor="#252525" style="padding: 2px">';
                echo $this->getFileLinkStartTag($fileObj) . $tag . '</a>';
                echo '</td></tr></table>';
                echo "</td></tr>\n";
                echo "    <tr><td align='center'>\n    "
                   . $this->getFileLinkStartTag($fileObj)
                   . '<b>' . $fileObj->title . '</b></a>';
                echo "</td></tr></table>\n";
                echo "</td>\n";
                if (($i + 1) % $cols != 0)
                    echo "  <td style='width: 1.5em'>&nbsp;</td>\n";
                else
                    echo "  <td width='*' nowrap> &nbsp; </td>\n";
            }
            // Forward to the next image.
            $i++;
            if (!$bHaveSeparators && $bIsFirstRow &&
                ($groupObj->fileCount % $cols == 1))
            {
                // There is one lonely image: only 2 images in the first row.
                $i++;
            }
            $bIsFirstRow = false;
            $fileObj = &$fileObj->next;
            // Print the row end.
            if (!is_object($fileObj))
            {
                while ($i++ % $cols != 0)
                    echo "  <td style='width: 1.5em'>&nbsp;</td>\n";
                echo "  <td width='*' nowrap> &nbsp; </td>\n";
            }
            if ($i % $cols == 0 || !is_object($fileObj))
                echo " </tr>\n";
        }
        echo "</table>\n\n";
    } // showFiles

    /* Debug method. */
    function dump ($indent)
    {
        echo "<pre>\nSeries \"<b>" . $this->title
            . "</b>\"\n All group names that must be repeated below:\n     ";
        $groupObj = &$this->allGroupsFirst;
        while (is_object($groupObj))
        {
            echo $groupObj->fileName . " ";
            $groupObj = &$groupObj->nextInAllGroups;
        }
        echo "\n";
        parent::dump(1);
        echo "End Series\n</pre>\n";
    } // dump
} // SeriesObject
?>
