/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: AboutDialog
    Created: 2 January, 2003
        $Id: AboutDialog.java 41 2006-01-14 15:49:02Z Dirk $
  $Revision: 41 $
      $Date: 2006-01-14 16:49:02 +0100 (Sa, 14 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.dialog;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;

import javax.swing.JDialog;

import com.dgrossmann.photo.AppInfo;

/**
 * The <i>About J Photo Explorer</i> dialog.
 */
public class AboutDialog extends JDialog
{
    /**
     * Creates a new <tt>AboutDialog</tt> form instance.
     * @param parent - Parent frame of this dialog
     * @param modal - <tt>True</tt> for a modal dialog
     */
    public AboutDialog (Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.setResizable(false);
        // Set the name and version strings.
        this.setTitle("About " + AppInfo.APP_NAME);
        versionLabel.setText("Version " + AppInfo.getVersionString());
        dateLabel.setText(AppInfo.getBuildDate(false));
        copyrightLabel.setText("Copyright  " + AppInfo.BUILD_YEAR
            + " by Dirk S. Grossmann");
        // Set the Credits-Font.
        Font fn = versionLabel.getFont();
        Font newFont;
        newFont = fn.deriveFont(Font.BOLD, 14.0F);
        versionLabel.setFont(newFont);
        copyrightLabel.setFont(newFont);
        // Position centered in the parent dialog.
        Rectangle parentRect, thisRect;
        parentRect = parent.getBounds();
        thisRect = this.getBounds();
        thisRect.x = parentRect.x + (parentRect.width - thisRect.width) / 2;
        thisRect.y = parentRect.y + (parentRect.height - thisRect.height) / 2;
        if (thisRect.x < 0)
            thisRect.x = 0;
        if (thisRect.y < 0)
            thisRect.y = 0;
        this.setBounds(thisRect);
    } // AboutDialog

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        java.awt.GridBagConstraints gridBagConstraints;

        descPanel = new javax.swing.JPanel();
        versionLabel = new javax.swing.JLabel();
        dateLabel = new javax.swing.JLabel();
        copyrightLabel = new javax.swing.JLabel();
        iconLabel = new javax.swing.JLabel();
        closeButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("About");
        addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                closeDialog(evt);
            }
        });

        descPanel.setLayout(new java.awt.GridBagLayout());

        versionLabel.setText("Version");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(84, 72, 0, 0);
        descPanel.add(versionLabel, gridBagConstraints);

        dateLabel.setText("of");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 72, 0, 0);
        descPanel.add(dateLabel, gridBagConstraints);

        copyrightLabel.setForeground(new java.awt.Color(255, 255, 255));
        copyrightLabel.setText("Copyright");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 1, 0);
        descPanel.add(copyrightLabel, gridBagConstraints);

        iconLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/jp-logo.jpg")));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        descPanel.add(iconLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        getContentPane().add(descPanel, gridBagConstraints);

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                closeButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(closeButton, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_closeButtonActionPerformed
    {//GEN-HEADEREND:event_closeButtonActionPerformed
        this.setVisible(false);
    }//GEN-LAST:event_closeButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt)
    {//GEN-FIRST:event_closeDialog
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_closeDialog
  
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton closeButton;
    private javax.swing.JLabel copyrightLabel;
    private javax.swing.JLabel dateLabel;
    private javax.swing.JPanel descPanel;
    private javax.swing.JLabel iconLabel;
    private javax.swing.JLabel versionLabel;
    // End of variables declaration//GEN-END:variables
    
} // AboutDialog
