/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: AssocTableMouseListener
    Created: 2 January, 2003
        $Id: AssocTableMouseListener.java 36 2006-01-06 18:55:22Z Dirk $
  $Revision: 36 $
      $Date: 2006-01-06 19:55:22 +0100 (Fr, 06 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.ui.dialog;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * Mouse listener for a double-click in the file list table of the <i>Associate
 * File with Reference</i> dialog.
 */
public class AssocTableMouseListener extends MouseAdapter
{
    private AssociateDialog m_parent;
    
    /** Creates a new <tt>AssocTableMouseListener</tt> instance. */
    public AssocTableMouseListener (AssociateDialog parent)
    {
        super();
        m_parent = parent;
    } // AssocTableMouseListener
    
    /** Mouse clicked handler that exits the dialog. */
    public void mouseClicked (MouseEvent e)
    {
        if (e.getClickCount() > 1)
            m_parent.invokeOkButtonAction();
    } // mouseClicked
} // AssocTableMouseListener
