/*
-------------------------------------------------------------------------------
  J  P h o t o - E x p l o r e r

  Copyright (c) 2006 by Dirk S. Grossmann.  All rights reserved.
-------------------------------------------------------------------------------
      Class: ExportProgress
    Created: 10 January, 2003
        $Id: ExportProgress.java 41 2006-01-14 15:49:02Z Dirk $
  $Revision: 41 $
      $Date: 2006-01-14 16:49:02 +0100 (Sa, 14 Jan 2006) $
    $Author: Dirk $
===============================================================================
*/

package com.dgrossmann.photo.webexport;

import java.awt.Dimension;

import com.dgrossmann.photo.dir.FileObject;

/**
 * Holder class for progress information during the Web export of images. It
 * may be accessed by serveral threads.
 */
public class ExportProgress
{
    private FileObject m_fileObj;
    private int        m_currentFileNumber;

    private String     m_outDirectory;
    private Dimension  m_originalSize;

    // Main image settings.
    private String     m_mainFileName;
    private Dimension  m_mainSize;
    private boolean    m_mainUpToDate, m_mainReady;

    // Index image settings.
    private String     m_indexFileName;
    private Dimension  m_indexSize;
    private boolean    m_indexUpToDate, m_indexReady;

    /**
     * Constructor of a <tt>ExportProgress</tt> instance.
     * @param fileObj - File object
     * @param currentFileNumber - Current file number in the list of all files
     * to be exported
     */
    public ExportProgress
        ( FileObject fileObj
        , int        currentFileNumber
        )
    {
        m_fileObj = fileObj;
        m_currentFileNumber = currentFileNumber;
        m_outDirectory = "";
        m_originalSize = null;
        m_mainFileName = m_indexFileName = "";
        m_mainSize = m_indexSize = null;
        m_mainUpToDate = m_indexUpToDate = false;
        m_mainReady = m_indexReady = false;
    } // ExportProgress

    public FileObject getFileObject ()
    {
        return m_fileObj;
    } // getFileObject
    public int getCurrentFileNumber ()
    {
        return m_currentFileNumber;
    } // getCurrentFileNumber

    public synchronized String getOutputDirectory ()
    {
        return m_outDirectory;
    } // getOutputDirectory
    public synchronized void setOutputDirectory (String dir)
    {
        m_outDirectory = dir;
    } // setOutputDirectory

    public synchronized Dimension getOriginalSize ()
    {
        return m_originalSize;
    } // getOriginalSize
    public synchronized void setOriginalSize (Dimension siz)
    {
        m_originalSize = siz;
    } // setOriginalSize

    //-------------------------------------------------------------------------

    public synchronized String getMainFileName ()
    {
        return m_mainFileName;
    } // getMainFileName
    public synchronized void setMainFileName (String name)
    {
        m_mainFileName = name;
    } // setMainFileName

    public synchronized Dimension getMainSize ()
    {
        return m_mainSize;
    } // getMainSize
    public synchronized void setMainSize (Dimension siz)
    {
        m_mainSize = siz;
    } // setMainSize

    public synchronized boolean isMainUpToDate ()
    {
        return m_mainUpToDate;
    } // isMainUpToDate

    public synchronized void setMainUpToDate (boolean val)
    {
        m_mainUpToDate = val;
        if (val)
            m_mainReady = true;
    } // setMainUpToDate

    public synchronized boolean isMainReady ()
    {
        return m_mainReady;
    } // isMainReady

    public synchronized void setMainReady (boolean val)
    {
        m_mainReady = val;
    } // setMainReady

    //-------------------------------------------------------------------------

    public synchronized String getIndexFileName ()
    {
        return m_indexFileName;
    } // getIndexFileName

    public synchronized void setIndexFileName (String name)
    {
        m_indexFileName = name;
    } // setIndexFileName

    public synchronized Dimension getIndexSize ()
    {
        return m_indexSize;
    } // getIndexSize

    public synchronized void setIndexSize (Dimension siz)
    {
        m_indexSize = siz;
    } // setIndexSize

    public synchronized boolean isIndexUpToDate ()
    {
        return m_indexUpToDate;
    } // isIndexUpToDate

    public synchronized void setIndexUpToDate (boolean val)
    {
        m_indexUpToDate = val;
        if (val)
            m_indexReady = true;
    } // setIndexUpToDate

    public synchronized boolean isIndexReady ()
    {
        return m_indexReady;
    } // isIndexReady

    public synchronized void setIndexReady (boolean val)
    {
        m_indexReady = val;
    } // setIndexReady

    /**
     * Tests the equality with another export progress instance.
     * @param theOther - The other object to compare this instance with
     * @return <tt>True</tt> iff both are equal
     */
    public boolean equals (Object theOther)
    {
        if (!(theOther instanceof ExportProgress))
            return false;
        ExportProgress p = (ExportProgress) theOther;
        return (this == p || m_fileObj == p.m_fileObj);
    }
} // ExportProgress
